$(function (){
    $('#emailList').datagrid({
        fit : true,// 设置为true时铺满它所在的容器.
        fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
        nowrap : false,// 设置为true，当数据长度超出列宽时将会自动截取。
        striped : true,// 设置为true将交替显示行背景。
        collapsible : true,// 定义是否显示可折叠按钮。
        singleSelect : false,// 设置为true将只允许选择一行。
        border : false,
        remoteSort : false,// 定义是否通过远程服务器对数据排序。
        pagination : true,// 分页组件是否显示
        pageNumber : 1,// 起始页
        pageSize : 10,// 每页显示的记录条数，默认为10
        pageList : [ 10, 20, 50 ],// 每页显示多少行
        rownumbers : true,// 行号
        nowrap : 'nowrap',
        url : baseUrl + '/admin/N020/getEmailList.html',
        toolbar : '#tbar',
        frozenColumns : [ [ {
            field : 'select',
            title : 'select',
            width : 50,
            checkbox : true
            } ] ],
        columns : [ [ {
                field : 'ToUser',
                title : 'recipient',
                width : 100,
                align : 'center',
                sortable : true
            }, {
                field : 'EmailTitle',
                title : 'email theme',
                width : 80,
                sortable : true,
                align : 'center'
            }, {
                field : 'EmailContent',
                title : 'email content',
                width : 80,
                sortable : true,
                align : 'center'
            }, {
                field : 'fromUser',
                title : 'addressor',
                width : 40,
                sortable : true,
                align : 'center'
            }, {
                field : 'createDate',
                title : 'sending time',
                width : 40,
                sortable : true,
                align : 'center'
            }
            // , {
                // field : 'index',
                // title : '操作',
                // align : 'center',
                // width : 40,
                // formatter : operate
            // } 
        ] ]
        // 当数据载入成功时触发。
        // onLoadSuccess : function(data) {
            // $('.drop_course').linkbutton({
                // iconCls : 'icon-no',
                // plain : true
            // });
        // }
    });
});

//操作
function operate(value, rowData, rowIndex) {
    return "<a onclick='deleteEmail(" + value + ")' class='drop_course' >delete</a>";
}

// 查询
function queryEmail(){
    var queryData = {};
    $("#tbar input").each(function (i,n){
        queryData[$(n).attr("id")] = $(n).val();
    });
    
    $('#emailList').datagrid('load',queryData);
}

// 删除
function deleteEmail(id){
    $.messager.confirm('delete hint', 'make sure to delete the selected mail?', function(r) {
        if (r) {
            var ids = new Array();
            if(id == undefined){
                var items = $('#emailList').datagrid('getSelections');
                for(var i in items){
                    ids.push(items[i].index);
                }
            }else{
                    ids.push(id);
            }
            $.ajax({
                url: baseUrl + "/admin/N020/delEmail.html",
                data: {'ids':ids.toString()},
                type: 'post',
                success : function(){
                    $('#emailList').datagrid('reload');
                }
            });
        }
    });
}

//刷新
function reloadGrid() {
    $('#emailList').datagrid('clearSelections');
    $('#emailList').datagrid('reload');
}

function addEmail(){
    window.parent.openTab("write",baseUrl + "/admin/N020/manageAddEmail.html");
}
